---
title: 2024-12-26 Making a Debian Live Image
date: 2024-12-26T21:48:26+00:00
draft: true
tags:
  - sysadmin
  - ubuntu
  - debian
---
I needed to make an x86 livecd image for a really old computer with a desktop environment and couldn't find any clear instructions on how to do it. Here we go!

First, install live-build and the debian keyrings:
```bash
sudo apt install live-build debian-keyring debian-archive-keyring
```

Now, create a directory to hold your build:
```bash
mkdir live-default && cd live-default
```

Create the build files:
```
lb config -a i386 --mode debian -d bookworm --mirror-chroot http://deb.debian.org/debian --security false
```
Use i386 for x86, amd64 for x64. Note security is disabled here because it's broken and we need to add it separately.

Create a list for packages to install, in my case xfce desktop:
```bash
touch config/package-lists/my.list.chroot
echo "task-xfce-desktop" >> config/package-lists/my.list.chroot
echo "task-british-desktop" >> config/package-lists/my.list.chroot
```

Add security updates back in:
```bash
echo "deb http://security.debian.org/debian-security bookworm-security main contrib non-free" >> config/archives/security.list.chroot
echo "deb http://security.debian.org/debian-security bookworm-security main contrib non-free" >> config/archives/security.list.binary
```

Now clean and build the image:
```bash
sudo lb clean
sudo lb build
```

```
deb https://security.debian.org/debian-security bookworm-security main contrib non-free
```